/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.IEError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IERioGrandeDoSulValidator
implements Validator<String> {
    private final boolean isFormatted;
    public static final Pattern FORMATED = Pattern.compile("[0-4]\\d{2}\\/\\d{7}");
    public static final Pattern UNFORMATED = Pattern.compile("([0-4]\\d{2})\\d{7}");
    private final BaseValidator baseValidator;

    public IERioGrandeDoSulValidator() {
        this(true);
    }

    public IERioGrandeDoSulValidator(boolean isFormatted) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
    }

    public IERioGrandeDoSulValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String IE) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (IE != null) {
            String unformatedIE = this.checkForCorrectFormat(IE, errors);
            if (errors.isEmpty()) {
                if (!this.hasValidCheckDigits(unformatedIE)) {
                    errors.add(IEError.INVALID_CHECK_DIGITS);
                }
                if (!this.hasValidMunicipality(unformatedIE)) {
                    errors.add(IEError.INVALID_MUNICIPALITY);
                }
            }
        }
        return errors;
    }

    private boolean hasValidMunicipality(String unformatedIE) {
        int municipalityInt;
        String municipality = null;
        Matcher matcher = UNFORMATED.matcher(unformatedIE);
        if (matcher.matches()) {
            municipality = matcher.replaceAll("$1");
        }
        boolean result = (municipalityInt = Integer.parseInt(municipality)) > 0 && municipalityInt <= 467;
        return result;
    }

    private String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!FORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!UNFORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie;
        }
        return unformatedIE;
    }

    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        DigitoPara digitoPara = new DigitoPara(iESemDigito);
        digitoPara.complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11);
        return digitoPara.calcula();
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        this.baseValidator.assertValid(this.getInvalidValues(cpf));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cpf));
    }
}

