/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IERioGrandeDoNorteValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("20\\.(\\d\\.)?\\d{3}\\.\\d{3}\\-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("20\\d{7,8}");

    public IERioGrandeDoNorteValidator() {
        super(true);
    }

    public IERioGrandeDoNorteValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IERioGrandeDoNorteValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).comMultiplicadoresDeAte(2, 10).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).calcula();
    }
}

