/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IEMaranhaoValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("12\\.\\d{3}\\.?\\d{3}-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("(12)\\d{7}");

    public IEMaranhaoValidator() {
        super(true);
    }

    public IEMaranhaoValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEMaranhaoValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        DigitoPara digitoPara = new DigitoPara(iESemDigito);
        digitoPara.complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11);
        return digitoPara.calcula();
    }
}

