/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IECearaValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("\\d{2}\\.\\d{3}\\.?\\d{3}-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("\\d{9}");

    public IECearaValidator() {
        super(true);
    }

    public IECearaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IECearaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).calcula();
    }
}

