/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IEAmapaValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("(03)[.](\\d{3})\\.?(\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(03)(\\d{3})(\\d{3})(\\d{1})");

    public IEAmapaValidator() {
        super(true);
    }

    public IEAmapaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEAmapaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        int ie = Integer.parseInt(iESemDigito);
        String p = "0";
        String d = "0";
        if (3000001 <= ie && ie <= 3017000) {
            p = "5";
        } else if (3017001 <= ie && ie <= 3019022) {
            p = "9";
            d = "1";
        }
        return new DigitoPara(iESemDigito).addDigito(p).comMultiplicadoresDeAte(1, 9).complementarAoModulo().trocandoPorSeEncontrar("0", 10).trocandoPorSeEncontrar(d, 11).calcula();
    }
}

