/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.RenavamFormatter;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.RenavamError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RenavamValidator
implements Validator<String> {
    public static final Pattern FORMATED = Pattern.compile("(\\d{4})[.](\\d{6})-(\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{4})(\\d{6})(\\d{1})");
    private boolean isFormatted = false;
    private MessageProducer messageProducer;

    public RenavamValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public RenavamValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.messageProducer = new SimpleMessageProducer();
    }

    public RenavamValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.messageProducer = messageProducer;
    }

    @Override
    public void assertValid(String renavam) {
        List<ValidationMessage> errors = this.getInvalidValues(renavam);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String renavam) {
        return this.getInvalidValues(renavam);
    }

    private List<ValidationMessage> getInvalidValues(String renavam) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (renavam != null) {
            String digitoCalculado;
            renavam = this.formataPadraoNovo(renavam);
            if (this.isFormatted && !FORMATED.matcher(renavam).matches()) {
                errors.add(this.messageProducer.getMessage(RenavamError.INVALID_FORMAT));
            }
            String unformatedRenavam = null;
            try {
                unformatedRenavam = new RenavamFormatter().unformat(renavam);
            }
            catch (IllegalArgumentException e) {
                errors.add(this.messageProducer.getMessage(RenavamError.INVALID_DIGITS));
                return errors;
            }
            if (unformatedRenavam.length() != 11 || !unformatedRenavam.matches("[0-9]*")) {
                errors.add(this.messageProducer.getMessage(RenavamError.INVALID_DIGITS));
            }
            String renavamSemDigito = unformatedRenavam.substring(0, unformatedRenavam.length() - 1);
            String digito = unformatedRenavam.substring(unformatedRenavam.length() - 1);
            if (!digito.equals(digitoCalculado = this.calculaDigito(renavamSemDigito))) {
                errors.add(this.messageProducer.getMessage(RenavamError.INVALID_CHECK_DIGIT));
            }
        }
        return errors;
    }

    private String formataPadraoNovo(String renavam) {
        if (this.isFormatted && renavam.length() == 11 || !this.isFormatted && renavam.length() == 9) {
            return "00" + renavam;
        }
        return renavam;
    }

    private String calculaDigito(String renavamSemDigito) {
        return new DigitoPara(renavamSemDigito).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11).calcula();
    }

    @Override
    public boolean isEligible(String renavam) {
        boolean isEligible = this.isFormatted ? RenavamFormatter.FORMATTED.matcher(renavam).matches() : RenavamFormatter.UNFORMATTED.matcher(renavam).matches();
        return isEligible;
    }
}

