/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.NITFormatter;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.NITError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NITValidator
implements Validator<String> {
    public static final Pattern FORMATED = Pattern.compile("(\\d{3})[.](\\d{5})[.](\\d{2})-(\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{3})(\\d{5})(\\d{2})(\\d{1})");
    private boolean isFormatted = false;
    private MessageProducer messageProducer;

    public NITValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public NITValidator(boolean isFormatted) {
        this.messageProducer = new SimpleMessageProducer();
        this.isFormatted = isFormatted;
    }

    public NITValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.messageProducer = messageProducer;
        this.isFormatted = isFormatted;
    }

    private List<ValidationMessage> getInvalidValues(String nit) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (nit != null) {
            String digitosCalculados;
            if (this.isFormatted && !FORMATED.matcher(nit).matches()) {
                errors.add(this.messageProducer.getMessage(NITError.INVALID_FORMAT));
            }
            String unformatedNIT = null;
            try {
                unformatedNIT = new NITFormatter().unformat(nit);
            }
            catch (IllegalArgumentException e) {
                errors.add(this.messageProducer.getMessage(NITError.INVALID_DIGITS));
                return errors;
            }
            if (unformatedNIT.length() != 11 || !unformatedNIT.matches("[0-9]*")) {
                errors.add(this.messageProducer.getMessage(NITError.INVALID_DIGITS));
            }
            String nitSemDigito = unformatedNIT.substring(0, unformatedNIT.length() - 1);
            String digitos = unformatedNIT.substring(unformatedNIT.length() - 1);
            if (!digitos.equals(digitosCalculados = this.calculaDigitos(nitSemDigito))) {
                errors.add(this.messageProducer.getMessage(NITError.INVALID_CHECK_DIGITS));
            }
        }
        return errors;
    }

    private String calculaDigitos(String nitSemDigito) {
        return new DigitoPara(nitSemDigito).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11).calcula();
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String nit) {
        List<ValidationMessage> errors = this.getInvalidValues(nit);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String nit) {
        return this.getInvalidValues(nit);
    }
}

