/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.CPFFormatter;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.CPFError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CPFValidator
implements Validator<String> {
    public static final Pattern FORMATED = Pattern.compile("(\\d{3})[.](\\d{3})[.](\\d{3})-(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{3})(\\d{3})(\\d{3})(\\d{2})");
    private boolean isFormatted = false;
    private boolean isIgnoringRepeatedDigits = false;
    private MessageProducer messageProducer;

    public CPFValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public CPFValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.messageProducer = new SimpleMessageProducer();
    }

    public CPFValidator(boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
        this.messageProducer = new SimpleMessageProducer();
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted) {
        this(messageProducer, isFormatted, false);
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.messageProducer = messageProducer;
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
    }

    private List<ValidationMessage> getInvalidValues(String cpf) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (cpf != null) {
            String digitosCalculados;
            if (this.isFormatted && !FORMATED.matcher(cpf).matches()) {
                errors.add(this.messageProducer.getMessage(CPFError.INVALID_FORMAT));
            }
            String unformatedCPF = null;
            try {
                unformatedCPF = new CPFFormatter().unformat(cpf);
            }
            catch (IllegalArgumentException e) {
                errors.add(this.messageProducer.getMessage(CPFError.INVALID_DIGITS));
                return errors;
            }
            if (unformatedCPF.length() != 11 || !unformatedCPF.matches("[0-9]*")) {
                errors.add(this.messageProducer.getMessage(CPFError.INVALID_DIGITS));
            }
            if (!this.isIgnoringRepeatedDigits && this.hasAllRepeatedDigits(unformatedCPF)) {
                errors.add(this.messageProducer.getMessage(CPFError.REPEATED_DIGITS));
            }
            String cpfSemDigito = unformatedCPF.substring(0, unformatedCPF.length() - 2);
            String digitos = unformatedCPF.substring(unformatedCPF.length() - 2);
            if (!digitos.equals(digitosCalculados = this.calculaDigitos(cpfSemDigito))) {
                errors.add(this.messageProducer.getMessage(CPFError.INVALID_CHECK_DIGITS));
            }
        }
        return errors;
    }

    private String calculaDigitos(String cpfSemDigito) {
        DigitoPara digitoPara = new DigitoPara(cpfSemDigito);
        digitoPara.comMultiplicadoresDeAte(2, 11).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).mod(11);
        String digito1 = digitoPara.calcula();
        digitoPara.addDigito(digito1);
        String digito2 = digitoPara.calcula();
        return digito1 + digito2;
    }

    private boolean hasAllRepeatedDigits(String cpf) {
        for (int i = 1; i < cpf.length(); ++i) {
            if (cpf.charAt(i) == cpf.charAt(0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        List<ValidationMessage> errors = this.getInvalidValues(cpf);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.getInvalidValues(cpf);
    }
}

