/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.IEError;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class IESaoPauloProdutorRuralValidator
implements Validator<String> {
    private static final int MOD = 11;
    private static final String MISSING_LEFT_SIDE_ZEROS = "00";
    private static final int DVX_POSITION = "00".length() + 9;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P12;
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.D, IEConstraints.Rotina.POS_IE};
    private static final DigitoVerificadorInfo DVX_INFO = new DigitoVerificadorInfo(0, rotinas, 11, DVX_MULTIPLIERS, DVX_POSITION);
    private static final ValidadorDeDV DVX_CHECKER = new ValidadorDeDV(DVX_INFO);
    private final boolean isFormatted;
    public static final Pattern FORMATED = Pattern.compile("P-\\d{8}\\.\\d{1}/\\d{3}");
    public static final Pattern UNFORMATED = Pattern.compile("P\\d{12}");
    private final BaseValidator baseValidator;

    public IESaoPauloProdutorRuralValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String ie) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (ie != null) {
            String unformatedIE = this.checkForCorrectFormat(ie, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedIE)) {
                errors.add(IEError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!FORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!UNFORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        }
        return unformatedIE;
    }

    private boolean hasValidCheckDigits(String value) {
        String testedValue = MISSING_LEFT_SIDE_ZEROS + value;
        return DVX_CHECKER.isDVValid(testedValue);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        this.baseValidator.assertValid(this.getInvalidValues(cpf));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cpf));
    }
}

