/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.format.Formatter;
import br.com.caelum.stella.format.LeftSideZerosFormatter;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;

public class IEConstraints {
    public static final Formatter PRE_VALIDATION_FORMATTER = new LeftSideZerosFormatter(14);
    public static final Integer[] P1 = new Integer[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P2 = new Integer[]{5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 0, 0};
    public static final Integer[] P3 = new Integer[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 0, 2};
    public static final Integer[] P4 = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P5 = new Integer[]{0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0};
    public static final Integer[] P6 = new Integer[]{0, 0, 0, 9, 8, 0, 0, 7, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P7 = new Integer[]{5, 4, 3, 2, 1, 9, 8, 7, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P8 = new Integer[]{8, 7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P9 = new Integer[]{7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 0, 0};
    public static final Integer[] P10 = new Integer[]{0, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0};
    public static final Integer[] P11 = new Integer[]{0, 3, 2, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 0};
    public static final Integer[] P12 = new Integer[]{0, 0, 1, 3, 4, 5, 6, 7, 8, 10, 0, 0, 0, 0};
    public static final Integer[] P13 = new Integer[]{0, 0, 3, 2, 10, 9, 8, 7, 6, 5, 4, 3, 2, 0};

    public static enum Rotina implements RotinaDeDigitoVerificador
    {
        A{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer[] a = info.getPesos();
                Integer[] b = parameter.getNumeros();
                Integer result = parameter.getResult();
                for (int i = 0; i < a.length; ++i) {
                    result = result + a[i] * b[i] / 10;
                }
                return result;
            }
        }
        ,
        B{

            @Override
            public Integer transform(RotinaParameters parameter) {
                return 10 * parameter.getResult();
            }
        }
        ,
        C{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer x = parameter.getResult();
                return x + (5 + 4 * info.getFator());
            }
        }
        ,
        D{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer x = parameter.getResult();
                return x % info.getMod();
            }
        }
        ,
        E{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer x = parameter.getResult();
                int result = info.getMod() - x % info.getMod();
                return result;
            }
        }
        ,
        POS_IE{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer x = parameter.getResult();
                if (x == 10) {
                    x = 0;
                } else if (x == 11) {
                    x = info.getFator();
                }
                return x;
            }
        }
        ,
        POS_IE_GOIAS{

            @Override
            public Integer transform(RotinaParameters parameter) {
                DigitoVerificadorInfo info = parameter.getDigitoVerificadorInfo();
                Integer x = parameter.getResult();
                if (x == 11) {
                    x = 0;
                } else if (x == 10) {
                    x = info.getFator();
                }
                return x;
            }
        };


        @Override
        public abstract Integer transform(RotinaParameters var1);
    }
}

