/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.regex.Pattern;

public class IEBahiaValidator
extends AbstractIEValidator {
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final int DVX_POSITION = 14;
    private static final int DVY_POSITION = 13;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P2;
    private static final Integer[] DVY_MULTIPLIERS = IEConstraints.P3;
    private static final DigitoVerificadorInfo DVX_INFO_MOD11 = new DigitoVerificadorInfo(0, rotinas, 11, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER_MOD11 = new ValidadorDeDV(DVX_INFO_MOD11);
    private static final DigitoVerificadorInfo DVY_INFO_MOD11 = new DigitoVerificadorInfo(0, rotinas, 11, DVY_MULTIPLIERS, 13);
    private static final ValidadorDeDV DVY_CHECKER_MOD11 = new ValidadorDeDV(DVY_INFO_MOD11);
    private static final DigitoVerificadorInfo DVX_INFO_MOD10 = new DigitoVerificadorInfo(0, rotinas, 10, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER_MOD10 = new ValidadorDeDV(DVX_INFO_MOD10);
    private static final DigitoVerificadorInfo DVY_INFO_MOD10 = new DigitoVerificadorInfo(0, rotinas, 10, DVY_MULTIPLIERS, 13);
    private static final ValidadorDeDV DVY_CHECKER_MOD10 = new ValidadorDeDV(DVY_INFO_MOD10);
    public static final Pattern FORMATED = Pattern.compile("(\\d{6,7}-\\d{2})|(\\d{2,3}\\.\\d{3}\\.\\d{3})");
    public static final Pattern UNFORMATED = Pattern.compile("\\d{8,9}");

    public IEBahiaValidator() {
        super(true);
    }

    public IEBahiaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEBahiaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String value) {
        String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
        boolean result = false;
        char charToCheck = value.length() == 8 ? value.charAt(0) : value.charAt(1);
        switch (charToCheck) {
            case '6': 
            case '7': 
            case '9': {
                result = DVX_CHECKER_MOD11.isDVValid(testedValue) && DVY_CHECKER_MOD11.isDVValid(testedValue);
                break;
            }
            default: {
                result = DVX_CHECKER_MOD10.isDVValid(testedValue) && DVY_CHECKER_MOD10.isDVValid(testedValue);
            }
        }
        return result;
    }
}

