/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.IEError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractIEValidator
implements Validator<String> {
    private final boolean isFormatted;
    private final BaseValidator baseValidator;

    public AbstractIEValidator() {
        this(true);
    }

    public AbstractIEValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.baseValidator = new BaseValidator();
    }

    public AbstractIEValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String IE) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (IE != null) {
            String unformatedIE = this.checkForCorrectFormat(IE, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedIE)) {
                errors.add(IEError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    protected String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!this.getFormattedPattern().matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!this.getUnformattedPattern().matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie;
        }
        return unformatedIE;
    }

    protected abstract Pattern getUnformattedPattern();

    protected abstract Pattern getFormattedPattern();

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? this.getFormattedPattern().matcher(value).matches() : this.getUnformattedPattern().matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String IE) {
        this.baseValidator.assertValid(this.getInvalidValues(IE));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String IE) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(IE));
    }

    protected abstract boolean hasValidCheckDigits(String var1);
}

