/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;

public class ValidadorDeDV {
    private final DigitoVerificadorInfo info;

    public ValidadorDeDV(DigitoVerificadorInfo info) {
        this.info = info;
    }

    public boolean isDVValid(String digitos) {
        Integer dvCandidate = Integer.parseInt(digitos.substring(this.info.getPosicaoDoDv() - 1, this.info.getPosicaoDoDv()));
        return this.generateDV(digitos).equals(dvCandidate);
    }

    private Integer generateDV(String digitos) {
        Integer innerProduct;
        Integer[] intDigits = this.extractIntegerDigits(digitos);
        Integer result = innerProduct = this.innerProduct(this.info.getPesos(), intDigits);
        RotinaParameters parameters = new RotinaParameters(this.info, intDigits, innerProduct);
        for (RotinaDeDigitoVerificador rotina : this.info.getRotinas()) {
            result = rotina.transform(parameters);
            parameters.setResult(result);
        }
        return result;
    }

    private Integer[] extractIntegerDigits(String digitos) {
        Integer[] intDigits = new Integer[digitos.length()];
        for (int i = 0; i < digitos.length(); ++i) {
            intDigits[i] = Integer.parseInt(digitos.substring(i, i + 1));
        }
        return intDigits;
    }

    private Integer innerProduct(Integer[] a, Integer[] b) {
        Integer result = 0;
        for (int i = 0; i < a.length; ++i) {
            result = result + a[i] * b[i];
        }
        return result;
    }
}

