/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.TituloEleitoralFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.TituloEleitoralError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class TituloEleitoralValidator
implements Validator<String> {
    private final BaseValidator baseValidator;
    private final boolean isFormatted;
    private static final int MOD = 11;
    private static final int DV1_POSITION = 11;
    private static final int DV2_POSITION = 12;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer[] DV2_MULTIPLIERS = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 2};
    public static final Pattern FORMATED = Pattern.compile("(\\d{10})/(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{10})(\\d{2})");
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new Rotina[]{Rotina.POS_PRODUTO_INTERNO}, 11, DV1_MULTIPLIERS, 11);
    private static final DigitoVerificadorInfo DV2_INFO = new DigitoVerificadorInfo(0, new Rotina[]{Rotina.POS_PRODUTO_INTERNO}, 11, DV2_MULTIPLIERS, 12);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    private static final ValidadorDeDV DV2_CHECKER = new ValidadorDeDV(DV2_INFO);

    public TituloEleitoralValidator(boolean isFormatted) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
    }

    public TituloEleitoralValidator() {
        this(false);
    }

    public TituloEleitoralValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    public TituloEleitoralValidator(MessageProducer messageProducer) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = false;
    }

    private List<InvalidValue> getInvalidValues(String tituloDeEleitor) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (tituloDeEleitor != null) {
            if (!this.isEligible(tituloDeEleitor)) {
                if (this.isFormatted) {
                    errors.add(TituloEleitoralError.INVALID_FORMAT);
                } else {
                    errors.add(TituloEleitoralError.INVALID_DIGITS);
                }
            } else {
                String unformated;
                if (this.isFormatted) {
                    TituloEleitoralFormatter formatter = new TituloEleitoralFormatter();
                    unformated = formatter.unformat(tituloDeEleitor);
                } else {
                    unformated = tituloDeEleitor;
                }
                if (!this.hasValidCheckDigits(unformated)) {
                    errors.add(TituloEleitoralError.INVALID_CHECK_DIGITS);
                }
                if (this.hasCodigoDeEstadoInvalido(tituloDeEleitor)) {
                    errors.add(TituloEleitoralError.INVALID_CODIGO_DE_ESTADO);
                }
            }
        }
        return errors;
    }

    private boolean hasCodigoDeEstadoInvalido(String tituloDeEleitor) {
        int length = tituloDeEleitor.length();
        int codigo = this.isFormatted ? Integer.parseInt(tituloDeEleitor.substring(length - 5, length - 3)) : Integer.parseInt(tituloDeEleitor.substring(length - 4, length - 2));
        return codigo < 1 || codigo > 28;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value) && DV2_CHECKER.isDVValid(value);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String tituloDeEleitor) {
        this.baseValidator.assertValid(this.getInvalidValues(tituloDeEleitor));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String tituloDeEleitor) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(tituloDeEleitor));
    }

    private static enum Rotina implements RotinaDeDigitoVerificador
    {
        POS_PRODUTO_INTERNO{

            @Override
            public Integer transform(RotinaParameters parameter) {
                Integer mod = parameter.getDigitoVerificadorInfo().getMod();
                Integer result = parameter.getResult() % mod;
                result = result < 2 ? Integer.valueOf(0) : Integer.valueOf(11 - result);
                return result;
            }
        };

    }
}

