/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class LogicOrComposedValidator<T>
implements Validator<T> {
    public Validator<T>[] validators;
    public MessageProducer messageProducer;
    public InvalidValue invalidFormat = new InvalidValue(){

        @Override
        public String name() {
            return "INVALID_FORMAT";
        }
    };

    public LogicOrComposedValidator(MessageProducer messageProducer, boolean isFormatted, Class<Validator<T>> ... validatorClasses) {
        this.messageProducer = messageProducer;
        this.validators = new Validator[validatorClasses.length];
        int i = 0;
        for (Class<Validator<T>> clazz : validatorClasses) {
            try {
                Constructor<Validator<T>> constructor = clazz.getConstructor(MessageProducer.class, Boolean.TYPE);
                constructor.setAccessible(true);
                this.validators[i++] = constructor.newInstance(messageProducer, isFormatted);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void assertValid(T value) {
        InvalidStateException lastException = null;
        boolean isValid = false;
        for (Validator<T> v : this.validators) {
            if (!v.isEligible(value)) continue;
            try {
                v.assertValid(value);
                isValid = true;
                break;
            }
            catch (InvalidStateException e) {
                lastException = e;
            }
        }
        if (!isValid) {
            if (lastException != null) {
                throw lastException;
            }
            throw new InvalidStateException(this.messageProducer.getMessage(this.invalidFormat));
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(T value) {
        List<ValidationMessage> result = null;
        for (Validator<T> v : this.validators) {
            if (!v.isEligible(value)) continue;
            List<ValidationMessage> invalidMessages = v.invalidMessagesFor(value);
            result = invalidMessages;
            if (invalidMessages.isEmpty()) break;
        }
        if (result == null) {
            result = new ArrayList<ValidationMessage>();
            result.add(this.messageProducer.getMessage(this.invalidFormat));
        }
        return result;
    }

    @Override
    public boolean isEligible(T object) {
        boolean result = false;
        for (Validator<T> v : this.validators) {
            if (!v.isEligible(object)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setInvalidFormat(InvalidValue invalidFormat) {
        this.invalidFormat = invalidFormat;
    }
}

