/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.CPFFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaComumDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.CPFError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CPFValidator
implements Validator<String> {
    private final BaseValidator baseValidator;
    private static final int MOD = 11;
    private final boolean isFormatted;
    private final boolean isIgnoringRepeatedDigits;
    public static final Pattern FORMATED = Pattern.compile("(\\d{3})[.](\\d{3})[.](\\d{3})-(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{3})(\\d{3})(\\d{3})(\\d{2})");
    private static final Integer DV1_POSITION = 10;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer DV2_POSITION = 11;
    private static final Integer[] DV2_MULTIPLIERS = new Integer[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaComumDeDigitoVerificador()}, 11, DV1_MULTIPLIERS, DV1_POSITION);
    private static final DigitoVerificadorInfo DV2_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaComumDeDigitoVerificador()}, 11, DV2_MULTIPLIERS, DV2_POSITION);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    private static final ValidadorDeDV DV2_CHECKER = new ValidadorDeDV(DV2_INFO);

    public CPFValidator() {
        this(true);
    }

    public CPFValidator(boolean isFormatted) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = false;
    }

    public CPFValidator(boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted) {
        this(messageProducer, isFormatted, false);
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
    }

    private List<InvalidValue> getInvalidValues(String cpf) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (cpf != null) {
            if (!this.isEligible(cpf)) {
                if (this.isFormatted) {
                    errors.add(CPFError.INVALID_FORMAT);
                } else {
                    errors.add(CPFError.INVALID_DIGITS);
                }
            } else {
                String unformatedCPF;
                if (this.isFormatted) {
                    CPFFormatter formatter = new CPFFormatter();
                    unformatedCPF = formatter.unformat(cpf);
                } else {
                    unformatedCPF = cpf;
                }
                if (errors.isEmpty() && !this.isIgnoringRepeatedDigits && this.hasAllRepeatedDigits(unformatedCPF)) {
                    errors.add(CPFError.REPEATED_DIGITS);
                }
                if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedCPF)) {
                    errors.add(CPFError.INVALID_CHECK_DIGITS);
                }
            }
        }
        return errors;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value) && DV2_CHECKER.isDVValid(value);
    }

    private boolean hasAllRepeatedDigits(String cpf) {
        for (int i = 1; i < cpf.length(); ++i) {
            if (cpf.charAt(i) == cpf.charAt(0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        this.baseValidator.assertValid(this.getInvalidValues(cpf));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cpf));
    }
}

