/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.regex.Pattern;

public class IEGoiasValidator
extends AbstractIEValidator {
    private static final int MOD = 11;
    private static final int DVX_POSITION = 14;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P1;
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE_GOIAS};
    private static final DigitoVerificadorInfo DVX_INFO_FATOR1 = new DigitoVerificadorInfo(1, rotinas, 11, DVX_MULTIPLIERS, 14);
    private static final DigitoVerificadorInfo DVX_INFO_FATOR0 = new DigitoVerificadorInfo(0, rotinas, 11, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER_FATOR1 = new ValidadorDeDV(DVX_INFO_FATOR1);
    private static final ValidadorDeDV DVX_CHECKER_FATOR0 = new ValidadorDeDV(DVX_INFO_FATOR0);
    public static final Pattern FORMATED = Pattern.compile("(1[015])[.](\\d{3})[.](\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(1[015])(\\d{3})(\\d{3})(\\d{1})");

    public IEGoiasValidator() {
        super(true);
    }

    public IEGoiasValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEGoiasValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String value) {
        boolean result;
        int ie = Integer.parseInt(value);
        if (ie == 110944020 || ie == 110944021) {
            result = true;
        } else {
            String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
            ValidadorDeDV validadorDeDV = null;
            validadorDeDV = 101031051 <= ie && ie <= 101199979 ? DVX_CHECKER_FATOR1 : DVX_CHECKER_FATOR0;
            result = validadorDeDV.isDVValid(testedValue);
        }
        return result;
    }
}

