/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import java.util.ArrayList;
import java.util.List;

public class BaseValidator {
    private final MessageProducer messageProducer;

    public BaseValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public BaseValidator(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    public List<ValidationMessage> generateValidationMessages(List<InvalidValue> invalidValues) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (InvalidValue invalidValue : invalidValues) {
            ValidationMessage message = this.messageProducer.getMessage(invalidValue);
            messages.add(message);
        }
        return messages;
    }

    public void assertValid(List<InvalidValue> invalidValues) {
        if (!invalidValues.isEmpty()) {
            throw new InvalidStateException(this.generateValidationMessages(invalidValues));
        }
    }
}

