/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.regex.Pattern;

public class IEAmapaValidator
extends AbstractIEValidator {
    private static final int MOD = 11;
    private static final int DVX_POSITION = 14;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P1;
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO1 = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.C, IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO2 = ROTINAS_CASO1;
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO3 = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final DigitoVerificadorInfo DVX_INFO_CASO1 = new DigitoVerificadorInfo(0, ROTINAS_CASO1, 11, DVX_MULTIPLIERS, 14);
    private static final DigitoVerificadorInfo DVX_INFO_CASO2 = new DigitoVerificadorInfo(1, ROTINAS_CASO2, 11, DVX_MULTIPLIERS, 14);
    private static final DigitoVerificadorInfo DVX_INFO_CASO3 = new DigitoVerificadorInfo(0, ROTINAS_CASO3, 11, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER_CASO1 = new ValidadorDeDV(DVX_INFO_CASO1);
    private static final ValidadorDeDV DVX_CHECKER_CASO2 = new ValidadorDeDV(DVX_INFO_CASO2);
    private static final ValidadorDeDV DVX_CHECKER_CASO3 = new ValidadorDeDV(DVX_INFO_CASO3);
    public static final Pattern FORMATED = Pattern.compile("(03)[.](\\d{3})\\.?(\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(03)(\\d{3})(\\d{3})(\\d{1})");

    public IEAmapaValidator() {
        super(true);
    }

    public IEAmapaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEAmapaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String value) {
        int ie = Integer.parseInt(value) / 10;
        String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
        ValidadorDeDV validadorDeDV = null;
        if (3000001 <= ie && ie <= 3017000) {
            validadorDeDV = DVX_CHECKER_CASO1;
        } else if (3017001 <= ie && ie <= 3019022) {
            validadorDeDV = DVX_CHECKER_CASO2;
        } else if (3019023 <= ie) {
            validadorDeDV = DVX_CHECKER_CASO3;
        }
        boolean result = validadorDeDV.isDVValid(testedValue);
        return result;
    }
}

