/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.CNPJFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaComumDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.CNPJError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CNPJValidator
implements Validator<String> {
    private final BaseValidator baseValidator;
    private final boolean isFormatted;
    private static final int MOD = 11;
    private static final int DV1_POSITION = 13;
    private static final int DV2_POSITION = 14;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer[] DV2_MULTIPLIERS = new Integer[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    public static final Pattern FORMATED = Pattern.compile("(\\d{2})[.](\\d{3})[.](\\d{3})/(\\d{4})-(\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{2})(\\d{3})(\\d{3})(\\d{4})(\\d{2})");
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new RotinaComumDeDigitoVerificador[]{new RotinaComumDeDigitoVerificador()}, 11, DV1_MULTIPLIERS, 13);
    private static final DigitoVerificadorInfo DV2_INFO = new DigitoVerificadorInfo(0, new RotinaComumDeDigitoVerificador[]{new RotinaComumDeDigitoVerificador()}, 11, DV2_MULTIPLIERS, 14);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    private static final ValidadorDeDV DV2_CHECKER = new ValidadorDeDV(DV2_INFO);

    public CNPJValidator() {
        this(true);
    }

    public CNPJValidator(boolean isFormatted) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
    }

    public CNPJValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String cnpj) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (cnpj != null) {
            if (!this.isEligible(cnpj)) {
                if (this.isFormatted) {
                    errors.add(CNPJError.INVALID_FORMAT);
                } else {
                    errors.add(CNPJError.INVALID_DIGITS);
                }
            } else {
                String unformatedCNPJ;
                if (this.isFormatted) {
                    CNPJFormatter formatter = new CNPJFormatter();
                    unformatedCNPJ = formatter.unformat(cnpj);
                } else {
                    unformatedCNPJ = cnpj;
                }
                if (!this.hasValidCheckDigits(unformatedCNPJ)) {
                    errors.add(CNPJError.INVALID_CHECK_DIGITS);
                }
            }
        }
        return errors;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value) && DV2_CHECKER.isDVValid(value);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cnpj) {
        this.baseValidator.assertValid(this.getInvalidValues(cnpj));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cnpj) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cnpj));
    }
}

