/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IEPernambucoValidator
extends AbstractIEValidator {
    private static final int DVX_MOD = 11;
    private static final int DVY_MOD = 11;
    private static final String MISSING_ZEROS = "00000";
    private static final int DVX_POSITION = "00000".length() + 8;
    private static final int DVY_POSITION = "00000".length() + 9;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P2;
    private static final Integer[] DVY_MULTIPLIERS = IEConstraints.P13;
    private static final RotinaDeDigitoVerificador[] DVX_ROTINAS = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final RotinaDeDigitoVerificador[] DVY_ROTINAS = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final DigitoVerificadorInfo DVX_INFO = new DigitoVerificadorInfo(0, DVX_ROTINAS, 11, DVX_MULTIPLIERS, DVX_POSITION);
    private static final DigitoVerificadorInfo DVY_INFO = new DigitoVerificadorInfo(0, DVY_ROTINAS, 11, DVY_MULTIPLIERS, DVY_POSITION);
    private static final ValidadorDeDV DVX_CHECKER = new ValidadorDeDV(DVX_INFO);
    private static final ValidadorDeDV DVY_CHECKER = new ValidadorDeDV(DVY_INFO);
    public static final Pattern FORMATED = Pattern.compile("\\d{7}-\\d{2}");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{9})");
    private static final String REPLACEMENT = "00000$1";

    public IEPernambucoValidator() {
        super(true);
    }

    public IEPernambucoValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEPernambucoValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String value) {
        String testedValue = null;
        Matcher matcher = UNFORMATED.matcher(value);
        if (matcher.matches()) {
            testedValue = matcher.replaceAll(REPLACEMENT);
        }
        boolean DVXisValid = DVX_CHECKER.isDVValid(testedValue);
        boolean DVYisValid = DVY_CHECKER.isDVValid(testedValue);
        return DVXisValid && DVYisValid;
    }
}

