/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import br.com.caelum.stella.validation.ie.IEConstraints;
import java.util.regex.Pattern;

public class IEAcreValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("01(\\.\\d{3}){2}\\/\\d{3}\\-\\d{2}");
    public static final Pattern UNFORMATED = Pattern.compile("01\\d{11}");
    private static final int MOD = 11;
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final int DVX_POSITION = 14;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P1;
    private static final DigitoVerificadorInfo DVX_INFO = new DigitoVerificadorInfo(0, rotinas, 11, DVX_MULTIPLIERS, 14);
    static final ValidadorDeDV DVX_CHECKER = new ValidadorDeDV(DVX_INFO);
    private static final int DVY_POSITION = 13;
    private static final Integer[] DVY_MULTIPLIERS = IEConstraints.P2;
    private static final DigitoVerificadorInfo DVY_INFO = new DigitoVerificadorInfo(0, rotinas, 11, DVY_MULTIPLIERS, 13);
    static final ValidadorDeDV DVY_CHECKER = new ValidadorDeDV(DVY_INFO);

    public IEAcreValidator() {
        super(true);
    }

    public IEAcreValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEAcreValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String value) {
        String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
        return DVX_CHECKER.isDVValid(testedValue) && DVY_CHECKER.isDVValid(testedValue);
    }
}

