/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.RenavamFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaComumDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.RenavamError;
import java.util.ArrayList;
import java.util.List;

public class RenavamValidator
implements Validator<String> {
    private final BaseValidator baseValidator;
    private static final Integer fator = 0;
    private static final Integer mod = 11;
    private static final Integer[] pesos = new Integer[]{9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer posicaoDoDigitoVerificador = 9;
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{new RotinaComumDeDigitoVerificador()};
    private static final DigitoVerificadorInfo digitoVerificadorInfo = new DigitoVerificadorInfo(fator, rotinas, mod, pesos, posicaoDoDigitoVerificador);
    private static final ValidadorDeDV validatorDeDigitoVerificador = new ValidadorDeDV(digitoVerificadorInfo);
    private final boolean isFormatted;

    public RenavamValidator() {
        this(true);
    }

    public RenavamValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.baseValidator = new BaseValidator();
    }

    public RenavamValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.baseValidator = new BaseValidator(messageProducer);
    }

    @Override
    public void assertValid(String renavam) {
        this.baseValidator.assertValid(this.getInvalidValues(renavam));
    }

    private boolean isCheckDigitValid(String renavam) {
        return validatorDeDigitoVerificador.isDVValid(this.unformat(renavam));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String renavam) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(renavam));
    }

    private List<InvalidValue> getInvalidValues(String renavam) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (!this.isEligible(renavam)) {
            errors.add(RenavamError.INVALID_DIGITS);
        } else if (!this.isCheckDigitValid(renavam)) {
            errors.add(RenavamError.INVALID_CHECK_DIGIT);
        }
        return errors;
    }

    @Override
    public boolean isEligible(String renavam) {
        boolean isEligible = this.isFormatted ? RenavamFormatter.FORMATTED.matcher(renavam).matches() : RenavamFormatter.UNFORMATTED.matcher(renavam).matches();
        return isEligible;
    }

    private String unformat(String renavam) {
        String result = renavam;
        if (this.isFormatted) {
            result = new RenavamFormatter().unformat(renavam);
        }
        return result;
    }
}

