/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.format.NITFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.NITError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NITValidator
implements Validator<String> {
    private final BaseValidator baseValidator;
    private static final int MOD = 11;
    private final boolean isFormatted;
    private static final Integer DV1_POSITION = 11;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaPosProdutoInterno()}, 11, DV1_MULTIPLIERS, DV1_POSITION);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    public static final Pattern NIT_FORMATED = Pattern.compile("(\\d{3})[.](\\d{5})[.](\\d{2})-(\\d{1})");
    public static final Pattern NIT_UNFORMATED = Pattern.compile("(\\d{3})(\\d{5})(\\d{2})(\\d{1})");

    public NITValidator() {
        this(true);
    }

    public NITValidator(boolean isFormatted) {
        this.baseValidator = new BaseValidator();
        this.isFormatted = isFormatted;
    }

    public NITValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String nit) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (nit != null) {
            if (!this.isEligible(nit)) {
                if (this.isFormatted) {
                    errors.add(NITError.INVALID_FORMAT);
                } else {
                    errors.add(NITError.INVALID_DIGITS);
                }
            } else {
                String unformatedNit;
                if (this.isFormatted) {
                    NITFormatter formatter = new NITFormatter();
                    unformatedNit = formatter.unformat(nit);
                } else {
                    unformatedNit = nit;
                }
                if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedNit)) {
                    errors.add(NITError.INVALID_CHECK_DIGITS);
                }
            }
        }
        return errors;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? NIT_FORMATED.matcher(value).matches() : NIT_UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        this.baseValidator.assertValid(this.getInvalidValues(cpf));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cpf));
    }

    private static class RotinaPosProdutoInterno
    implements RotinaDeDigitoVerificador {
        private RotinaPosProdutoInterno() {
        }

        @Override
        public Integer transform(RotinaParameters parameter) {
            Integer mod = parameter.getDigitoVerificadorInfo().getMod();
            Integer result = parameter.getResult() % mod;
            result = result < 2 ? Integer.valueOf(0) : Integer.valueOf(11 - result);
            return result;
        }
    }
}

