/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.constraint.IEConstraints;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.error.IEError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEMaranhaoValidator
extends BaseValidator<String> {
    private static final int MOD = 11;
    private static final int DVX_POSITION = 14;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P1;
    private static final RotinaDeDigitoVerificador[] rotinas = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final DigitoVerificadorInfo DVX_INFO = new DigitoVerificadorInfo(0, rotinas, 11, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER = new ValidadorDeDV(DVX_INFO);
    private final boolean isFormatted;
    public static final Pattern FORMATED = Pattern.compile("(12)[.](\\d{3})[.](\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(12)(\\d{3})(\\d{3})(\\d{1})");

    public IEMaranhaoValidator() {
        this(true);
    }

    public IEMaranhaoValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public IEMaranhaoValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer);
        this.isFormatted = isFormatted;
    }

    @Override
    protected List<InvalidValue> getInvalidValues(String IE) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (IE != null) {
            String unformatedIE = this.checkForCorrectFormat(IE, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedIE)) {
                errors.add(IEError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!FORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!UNFORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie;
        }
        return unformatedIE;
    }

    private boolean hasValidCheckDigits(String value) {
        String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
        return DVX_CHECKER.isDVValid(testedValue);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }
}

