/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.constraint.IEConstraints;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.error.IEError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEAmapaValidator
extends BaseValidator<String> {
    private static final int MOD = 11;
    private static final int DVX_POSITION = 14;
    private static final Integer[] DVX_MULTIPLIERS = IEConstraints.P1;
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO1 = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.C, IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO2 = ROTINAS_CASO1;
    private static final RotinaDeDigitoVerificador[] ROTINAS_CASO3 = new RotinaDeDigitoVerificador[]{IEConstraints.Rotina.E, IEConstraints.Rotina.POS_IE};
    private static final DigitoVerificadorInfo DVX_INFO_CASO1 = new DigitoVerificadorInfo(0, ROTINAS_CASO1, 11, DVX_MULTIPLIERS, 14);
    private static final DigitoVerificadorInfo DVX_INFO_CASO2 = new DigitoVerificadorInfo(1, ROTINAS_CASO2, 11, DVX_MULTIPLIERS, 14);
    private static final DigitoVerificadorInfo DVX_INFO_CASO3 = new DigitoVerificadorInfo(0, ROTINAS_CASO3, 11, DVX_MULTIPLIERS, 14);
    private static final ValidadorDeDV DVX_CHECKER_CASO1 = new ValidadorDeDV(DVX_INFO_CASO1);
    private static final ValidadorDeDV DVX_CHECKER_CASO2 = new ValidadorDeDV(DVX_INFO_CASO2);
    private static final ValidadorDeDV DVX_CHECKER_CASO3 = new ValidadorDeDV(DVX_INFO_CASO3);
    private final boolean isFormatted;
    public static final Pattern FORMATED = Pattern.compile("(03)[.](\\d{3})[.](\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(03)(\\d{3})(\\d{3})(\\d{1})");

    public IEAmapaValidator() {
        this(true);
    }

    public IEAmapaValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public IEAmapaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer);
        this.isFormatted = isFormatted;
    }

    @Override
    protected List<InvalidValue> getInvalidValues(String IE) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (IE != null) {
            String unformatedIE = this.checkForCorrectFormat(IE, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedIE)) {
                errors.add(IEError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!FORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!UNFORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie;
        }
        return unformatedIE;
    }

    private boolean hasValidCheckDigits(String value) {
        int ie = Integer.parseInt(value) / 10;
        String testedValue = IEConstraints.PRE_VALIDATION_FORMATTER.format(value);
        ValidadorDeDV validadorDeDV = null;
        if (3000001 <= ie && ie <= 3017000) {
            validadorDeDV = DVX_CHECKER_CASO1;
        } else if (3017001 <= ie && ie <= 3019022) {
            validadorDeDV = DVX_CHECKER_CASO2;
        } else if (3019023 <= ie) {
            validadorDeDV = DVX_CHECKER_CASO3;
        }
        boolean result = validadorDeDV.isDVValid(testedValue);
        return result;
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }
}

