/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejectAllValidator<T>
implements Validator<T> {
    private final MessageProducer messageProducer;
    private final List<InvalidValue> invalidValues;

    public RejectAllValidator(MessageProducer messageProducer, InvalidValue ... invalidValues) {
        this.messageProducer = messageProducer;
        this.invalidValues = Arrays.asList(invalidValues);
    }

    @Override
    public void assertValid(T value) {
        List<InvalidValue> errors = this.invalidValues;
        if (!errors.isEmpty()) {
            throw new InvalidStateException(this.generateValidationMessages(errors));
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(T object) {
        ArrayList<ValidationMessage> invalidMessages = new ArrayList<ValidationMessage>();
        for (InvalidValue invalidValue : this.invalidValues) {
            invalidMessages.add(this.messageProducer.getMessage(invalidValue));
        }
        return invalidMessages;
    }

    @Override
    public boolean isEligible(T object) {
        return true;
    }

    private List<ValidationMessage> generateValidationMessages(List<InvalidValue> invalidValues) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (InvalidValue invalidValue : invalidValues) {
            ValidationMessage message = this.messageProducer.getMessage(invalidValue);
            messages.add(message);
        }
        return messages;
    }
}

