/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.constraint.NITConstraints;
import br.com.caelum.stella.format.NITFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.error.NITError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NITValidator
extends BaseValidator<String> {
    private static final int MOD = 11;
    private final boolean isFormatted;
    private static final Integer DV1_POSITION = 11;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaPosProdutoInterno()}, 11, DV1_MULTIPLIERS, DV1_POSITION);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);

    public NITValidator() {
        this(true);
    }

    public NITValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public NITValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer);
        this.isFormatted = isFormatted;
    }

    @Override
    protected List<InvalidValue> getInvalidValues(String nit) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (nit != null) {
            String unformatedNit = this.checkForCorrectFormat(nit, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedNit)) {
                errors.add(NITError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String string, List<InvalidValue> errors) {
        String unformatedNit;
        if (this.isFormatted) {
            if (!NITConstraints.NIT_FORMATED.matcher(string).matches()) {
                errors.add(NITError.INVALID_FORMAT);
            }
            unformatedNit = new NITFormatter().unformat(string);
        } else {
            if (!NITConstraints.NIT_UNFORMATED.matcher(string).matches()) {
                errors.add(NITError.INVALID_DIGITS);
            }
            unformatedNit = string;
        }
        return unformatedNit;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? NITConstraints.NIT_FORMATED.matcher(value).matches() : NITConstraints.NIT_FORMATED.matcher(value).matches();
        return result;
    }

    private static class RotinaPosProdutoInterno
    implements RotinaDeDigitoVerificador {
        private RotinaPosProdutoInterno() {
        }

        public Integer transform(RotinaParameters parameter) {
            Integer mod = parameter.getDigitoVerificadorInfo().getMod();
            Integer result = parameter.getResult() % mod;
            result = result < 2 ? Integer.valueOf(0) : Integer.valueOf(11 - result);
            return result;
        }
    }
}

