/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.constraint.CPFConstraints;
import br.com.caelum.stella.format.CPFFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RotinaDeDigitoVerificador;
import br.com.caelum.stella.validation.RotinaParameters;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.error.CPFError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPFValidator
extends BaseValidator<String> {
    private static final int MOD = 11;
    private final boolean isFormatted;
    private final boolean isIgnoringRepeatedDigits;
    private static final Integer DV1_POSITION = 10;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer DV2_POSITION = 11;
    private static final Integer[] DV2_MULTIPLIERS = new Integer[]{11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaPosProdutoInterno()}, 11, DV1_MULTIPLIERS, DV1_POSITION);
    private static final DigitoVerificadorInfo DV2_INFO = new DigitoVerificadorInfo(0, new RotinaDeDigitoVerificador[]{new RotinaPosProdutoInterno()}, 11, DV2_MULTIPLIERS, DV2_POSITION);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    private static final ValidadorDeDV DV2_CHECKER = new ValidadorDeDV(DV2_INFO);

    public CPFValidator() {
        this(true);
    }

    public CPFValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = true;
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer);
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = true;
    }

    public CPFValidator(MessageProducer messageProducer, boolean isFormatted, boolean isIgnoringRepeatedDigits) {
        super(messageProducer);
        this.isFormatted = isFormatted;
        this.isIgnoringRepeatedDigits = isIgnoringRepeatedDigits;
    }

    @Override
    protected List<InvalidValue> getInvalidValues(String cpf) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        if (cpf != null) {
            String unformatedCPF = this.checkForCorrectFormat(cpf, errors);
            if (errors.isEmpty() && !this.isIgnoringRepeatedDigits && this.hasAllRepeatedDigits(unformatedCPF)) {
                errors.add(CPFError.REPEATED_DIGITS);
            }
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedCPF)) {
                errors.add(CPFError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String string, List<InvalidValue> errors) {
        String unformatedCPF = null;
        if (this.isFormatted) {
            if (!CPFConstraints.CPF_FORMATED.matcher(string).matches()) {
                errors.add(CPFError.INVALID_FORMAT);
            }
            unformatedCPF = new CPFFormatter().unformat(string);
        } else {
            if (!CPFConstraints.CPF_UNFORMATED.matcher(string).matches()) {
                errors.add(CPFError.INVALID_DIGITS);
            }
            unformatedCPF = string;
        }
        return unformatedCPF;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value) && DV2_CHECKER.isDVValid(value);
    }

    private boolean hasAllRepeatedDigits(String cpf) {
        for (int i = 1; i < cpf.length(); ++i) {
            if (cpf.charAt(i) == cpf.charAt(0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? CPFConstraints.CPF_FORMATED.matcher(value).matches() : CPFConstraints.CPF_FORMATED.matcher(value).matches();
        return result;
    }

    private static class RotinaPosProdutoInterno
    implements RotinaDeDigitoVerificador {
        private RotinaPosProdutoInterno() {
        }

        public Integer transform(RotinaParameters parameter) {
            Integer mod = parameter.getDigitoVerificadorInfo().getMod();
            Integer result = parameter.getResult() % mod;
            result = result < 2 ? Integer.valueOf(0) : Integer.valueOf(11 - result);
            return result;
        }
    }
}

