/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.constraint.CNPJConstraints;
import br.com.caelum.stella.format.CNPJFormatter;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.DigitoVerificadorInfo;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.ValidadorDeDV;
import br.com.caelum.stella.validation.error.CNPJError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNPJValidator
extends BaseValidator<String> {
    private final boolean isFormatted;
    private static final int MOD = 11;
    private static final int DV1_POSITION = 13;
    private static final int DV2_POSITION = 14;
    private static final Integer[] DV1_MULTIPLIERS = new Integer[]{5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final Integer[] DV2_MULTIPLIERS = new Integer[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final DigitoVerificadorInfo DV1_INFO = new DigitoVerificadorInfo(0, new CNPJConstraints.Rotina[]{CNPJConstraints.Rotina.POS_PRODUTO_INTERNO}, 11, DV1_MULTIPLIERS, 13);
    private static final DigitoVerificadorInfo DV2_INFO = new DigitoVerificadorInfo(0, new CNPJConstraints.Rotina[]{CNPJConstraints.Rotina.POS_PRODUTO_INTERNO}, 11, DV2_MULTIPLIERS, 14);
    private static final ValidadorDeDV DV1_CHECKER = new ValidadorDeDV(DV1_INFO);
    private static final ValidadorDeDV DV2_CHECKER = new ValidadorDeDV(DV2_INFO);

    public CNPJValidator() {
        this(true);
    }

    public CNPJValidator(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public CNPJValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer);
        this.isFormatted = isFormatted;
    }

    @Override
    protected List<InvalidValue> getInvalidValues(String cnpj) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (cnpj != null) {
            String unformatedCNPJ = this.checkForCorrectFormat(cnpj, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedCNPJ)) {
                errors.add(CNPJError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String cnpj, List<InvalidValue> errors) {
        String unformatedCNPJ = null;
        if (this.isFormatted) {
            if (!CNPJConstraints.CNPJ_FORMATED.matcher(cnpj).matches()) {
                errors.add(CNPJError.INVALID_FORMAT);
            }
            unformatedCNPJ = new CNPJFormatter().unformat(cnpj);
        } else {
            if (!CNPJConstraints.CNPJ_UNFORMATED.matcher(cnpj).matches()) {
                errors.add(CNPJError.INVALID_DIGITS);
            }
            unformatedCNPJ = cnpj;
        }
        return unformatedCNPJ;
    }

    private boolean hasValidCheckDigits(String value) {
        return DV1_CHECKER.isDVValid(value) && DV2_CHECKER.isDVValid(value);
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? CNPJConstraints.CNPJ_FORMATED.matcher(value).matches() : CNPJConstraints.CNPJ_FORMATED.matcher(value).matches();
        return result;
    }
}

