/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseValidator<T>
implements Validator<T> {
    private final MessageProducer messageProducer;

    public BaseValidator() {
        this.messageProducer = new SimpleMessageProducer();
    }

    public BaseValidator(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    protected List<ValidationMessage> generateValidationMessages(List<InvalidValue> invalidValues) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (InvalidValue invalidValue : invalidValues) {
            ValidationMessage message = this.messageProducer.getMessage(invalidValue);
            messages.add(message);
        }
        return messages;
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(T value) {
        List<InvalidValue> invalidValues = this.getInvalidValues(value);
        List<ValidationMessage> messages = this.generateValidationMessages(invalidValues);
        return messages;
    }

    @Override
    public void assertValid(T value) {
        List<InvalidValue> errors = this.getInvalidValues(value);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(this.generateValidationMessages(errors));
        }
    }

    protected abstract List<InvalidValue> getInvalidValues(T var1);
}

