/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleValidationMessage;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidValue;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageProducer
implements MessageProducer {
    private final ResourceBundle bundle;

    public ResourceBundleMessageProducer(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public ValidationMessage getMessage(InvalidValue error) {
        String message;
        Locale locale = this.bundle.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String key = this.messageKeyFor(locale, error.getClass(), error);
        try {
            message = this.bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            message = key.replaceFirst("[.]", " : ").replaceAll("_", " ");
        }
        return new SimpleValidationMessage(message);
    }

    public String messageKeyFor(Locale locale, Class<? extends InvalidValue> errorClass, InvalidValue error) {
        String simpleName = errorClass.getSimpleName();
        String errorName = error.name();
        String key = simpleName + "." + errorName;
        return key.toLowerCase(locale);
    }
}

