/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.bean.validation.xml.logic;

import br.com.caelum.stella.bean.validation.xml.Choice;
import br.com.caelum.stella.bean.validation.xml.ChoiceItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.vidageek.mirror.dsl.Mirror;

public class StellaChoiceValidator
implements ConstraintValidator<Choice, Object> {
    public void initialize(Choice annotation) {
    }

    public boolean isValid(Object toValidate, ConstraintValidatorContext context) {
        Class<?> type = toValidate.getClass();
        if (!this.hasChoiceItens(toValidate)) {
            return this.validateChoice(toValidate, new Mirror().on(type).reflectAll().fields());
        }
        return this.validateChoice(toValidate, this.getChoiceItemAnnotatedFields(type));
    }

    private List<Field> getChoiceItemAnnotatedFields(Class<? extends Object> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : new Mirror().on(type).reflectAll().fields()) {
            if (new Mirror().on(field).reflect().annotation(ChoiceItem.class) == null) continue;
            result.add(field);
        }
        return result;
    }

    private boolean validateChoice(Object toValidate, List<Field> fields) {
        int nonNullFields = 0;
        for (Field field : fields) {
            Object object;
            if (field.getClass().isPrimitive() || (object = new Mirror().on(toValidate).get().field(field)) == null) continue;
            ++nonNullFields;
        }
        return nonNullFields == 1;
    }

    private boolean hasChoiceItens(Object toValidate) {
        for (Field f : new Mirror().on(toValidate.getClass()).reflectAll().fields()) {
            if (new Mirror().on(f).reflect().annotation(ChoiceItem.class) == null) continue;
            return true;
        }
        return false;
    }
}

