/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.bean.validation.logic;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.bean.validation.IE;
import br.com.caelum.stella.bean.validation.logic.AnnotationMessageProducer;
import br.com.caelum.stella.type.Estado;
import br.com.caelum.stella.validation.Validator;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.vidageek.mirror.dsl.Mirror;

public class StellaIEValidator
implements ConstraintValidator<IE, Object> {
    private Validator<String> stellaValidator;
    private IE ie;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value != null) {
            String ieValue = this.getIEValue(value);
            String estadoValue = this.getEstadoValue(value);
            AnnotationMessageProducer annotationMessageProducer = new AnnotationMessageProducer(this.ie);
            if (ieValue.trim().length() == 0) {
                return true;
            }
            try {
                Estado estado = Estado.valueOf((String)estadoValue);
                this.stellaValidator = estado.getIEValidator((MessageProducer)annotationMessageProducer, this.ie.formatted());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return this.stellaValidator.invalidMessagesFor((Object)ieValue).isEmpty();
        }
        return true;
    }

    public void initialize(IE ie) {
        this.ie = ie;
    }

    private String getEstadoValue(Object obj) {
        return new Mirror().on(obj).invoke().method(this.camelCaseGetFieldName(this.ie.estadoField())).withoutArgs().toString();
    }

    private String getIEValue(Object obj) {
        return new Mirror().on(obj).invoke().method(this.camelCaseGetFieldName(this.ie.ieField())).withoutArgs().toString();
    }

    private String camelCaseGetFieldName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }
}

