/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.srs.service;

import br.com.caelum.srs.SpacedRepetition;
import br.com.caelum.srs.dao.CardAnswerDAO;
import br.com.caelum.srs.dao.CardDAO;
import br.com.caelum.srs.model.AnswerKind;
import br.com.caelum.srs.model.Card;
import br.com.caelum.srs.model.CardAnswer;
import br.com.caelum.srs.model.Difficulty;
import br.com.caelum.srs.service.EditDistance;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.joda.time.DateTime;

@Dependent
public class CardAnswerer {
    private final CardAnswerDAO answers;
    private final CardDAO cards;

    @Inject
    public CardAnswerer(CardDAO cards, CardAnswerDAO answers) {
        this.cards = cards;
        this.answers = answers;
    }

    public CardAnswer answerFillTheBlank(SpacedRepetition repetition, long userId, List<String> acceptableAnswers, String guess, AnswerKind answerKind) {
        double difference = acceptableAnswers.stream().mapToDouble(s -> new EditDistance((String)s, guess).difference()).sorted().findFirst().orElseThrow(this.complain());
        Card card = this.cards.getOrCreate(repetition, userId);
        Difficulty difficulty = card.getState().difficultyFor(difference);
        return this.answer(repetition, userId, difficulty, answerKind);
    }

    public CardAnswer answer(SpacedRepetition repetition, long userId, Difficulty difficulty, AnswerKind answerKind) {
        Card card = this.cards.getOrCreate(repetition, userId);
        DateTime lastAnswerToday = this.cards.lastAnswerFromTodayOrElse(userId, DateTime.now());
        CardAnswer answer = card.answer(difficulty, lastAnswerToday, answerKind);
        this.answers.save(answer);
        return answer;
    }

    private Supplier<IllegalStateException> complain() {
        return () -> new IllegalStateException("Fill the blank exercise must have at least one answer");
    }
}

