/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.srs.model;

import br.com.caelum.srs.model.CardState;
import br.com.caelum.srs.model.Difficulty;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class Move {
    static final int STREAK_FOR_NEXT_DAY = 6;
    static final int ONE_DAY = 1440;
    static final double MAX_EASINESS = 2.48;
    @Enumerated(value=EnumType.STRING)
    private final CardState state;
    @Column(name="moveInterval")
    private final int interval;
    private final double easiness;

    protected Move() {
        this(null, 0, 0.0);
    }

    public Move(CardState state, int interval, double easiness) {
        this.state = state;
        this.interval = Math.min(interval, 525600);
        this.easiness = Math.min(easiness, 2.48);
    }

    public Move(CardState state, int interval) {
        this(state, interval, 2.48);
    }

    public CardState getState() {
        return this.state;
    }

    public double getEasiness() {
        return this.easiness;
    }

    public Move move(Difficulty difficulty, int blackoutStreak) {
        Move next = this.state.move(difficulty, this);
        if (blackoutStreak == 6) {
            return new Move(next.getState(), 1440, next.getEasiness());
        }
        return next;
    }

    public int getInterval() {
        return this.interval;
    }

    public Move move(Difficulty difficulty) {
        return this.move(difficulty, 0);
    }
}

