/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.srs.model;

import br.com.caelum.srs.SpacedRepetition;
import br.com.caelum.srs.model.AnswerKind;
import br.com.caelum.srs.model.CardAnswer;
import br.com.caelum.srs.model.CardState;
import br.com.caelum.srs.model.Difficulty;
import br.com.caelum.srs.model.LastAnswerResult;
import br.com.caelum.srs.model.Move;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Entity
public class Card {
    static final int STREAK_TO_REMOVE = 12;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private final Long studentId;
    private final Long repetitionId;
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    private final DateTime creationDate = DateTime.now();
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    private DateTime nextDisplayDate = DateTime.now();
    private int numberOfAnswers = 0;
    @Column(nullable=true)
    private int blackoutStreak = 0;
    @OneToOne(fetch=FetchType.LAZY)
    private CardAnswer lastAnswer;
    public static final int INFINITE_YEARS = 2000;

    public Card(SpacedRepetition repetition, Long studentId) {
        this.repetitionId = repetition != null ? repetition.getIdentifier() : 0L;
        this.studentId = studentId;
    }

    protected Card() {
        this(null, null);
    }

    public long nextIntervalInMinutes(Difficulty difficulty) {
        return this.getMove().move(difficulty).getInterval();
    }

    public CardAnswer answer(Difficulty difficulty, DateTime lastCardFromToday, AnswerKind answerKind) {
        Move currentMove = this.getMove();
        Move nextMove = currentMove.move(difficulty, this.blackoutStreak);
        ++this.numberOfAnswers;
        this.nextDisplayDate = lastCardFromToday.plusMinutes(nextMove.getInterval());
        if (this.nextDisplayDate.isBefore((ReadableInstant)DateTime.now())) {
            this.nextDisplayDate = DateTime.now().plusMinutes(nextMove.getInterval());
        }
        this.checkBlackoutStreak(difficulty);
        this.lastAnswer = new CardAnswer(this, difficulty, nextMove, answerKind);
        return this.lastAnswer;
    }

    private void checkBlackoutStreak(Difficulty difficulty) {
        this.blackoutStreak = Difficulty.BLACKOUT.equals((Object)difficulty) ? ++this.blackoutStreak : 0;
        if (this.blackoutStreak == 12) {
            this.nextDisplayDate = DateTime.now().plusYears(2000);
        }
    }

    public CardState getState() {
        return this.getMove().getState();
    }

    public LastAnswerResult getLastAnswerResult() {
        return Optional.ofNullable(this.lastAnswer).map(c -> c.getDifficulty().getLastAnswerResult()).orElse(LastAnswerResult.NO_ANSWERS);
    }

    private Move getMove() {
        return Optional.ofNullable(this.lastAnswer).map(answer -> answer.getMove()).orElse(new Move(CardState.LEARNING_STEP1, 1));
    }

    public boolean isRemoved() {
        return this.nextDisplayDate.isAfter((ReadableInstant)DateTime.now().plusYears(1000));
    }

    public DateTime getNextDisplayDate() {
        return this.nextDisplayDate;
    }

    public Long getStudentId() {
        return this.studentId;
    }

    public Long getRepetitionId() {
        return this.repetitionId;
    }
}

