/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.srs.dao;

import br.com.caelum.srs.SpacedRepetition;
import br.com.caelum.srs.dao.CardAnswerDAO;
import br.com.caelum.srs.model.Card;
import br.com.caelum.srs.model.CardAvailability;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.hibernate.Session;
import org.joda.time.DateTime;

@RequestScoped
public class CardDAO {
    public static final long MAX_FOR_TODAY = 100L;
    private final Session session;
    private final CardAnswerDAO answers;

    protected CardDAO() {
        this(null, null);
    }

    @Inject
    public CardDAO(Session session, CardAnswerDAO answers) {
        this.session = session;
        this.answers = answers;
    }

    public void save(List<Card> cards) {
        cards.forEach(arg_0 -> ((Session)this.session).save(arg_0));
    }

    public Card save(Card card) {
        this.session.save((Object)card);
        return card;
    }

    public Card load(Long id) {
        return (Card)this.session.load(Card.class, (Serializable)id);
    }

    public Long getRemainingForRepetitionToday(long userId) {
        long answersToday = this.repetitionsAnsweredToday(userId);
        long practiceForToday = Math.min(100L, this.getTotalCardsForRepetitionToday(userId));
        long remainingForToday = Math.max(100L - answersToday, 0L);
        return Math.min(remainingForToday, practiceForToday);
    }

    public Long repetitionsAnsweredToday(long userId) {
        return this.answers.repetitionsAnsweredToday(userId);
    }

    public Long getTotalCardsForRepetitionToday(long userId) {
        return (Long)this.session.createQuery("select count(*) from Card c where c.studentId = :studentId and nextDisplayDate < :tomorrowMidnight").setParameter("studentId", (Object)userId).setParameter("tomorrowMidnight", (Object)this.tomorrowMidnight()).uniqueResult();
    }

    public Long getNext(long userID, CardAvailability availability) {
        if (CardAvailability.UNLIMITED.equals((Object)availability)) {
            return this.getNextFor(userID);
        }
        if (this.answers.repetitionsAnsweredToday(userID) >= 100L) {
            return null;
        }
        return this.getNextFor(userID);
    }

    private Long getNextFor(long userID) {
        Optional<Card> answered = Optional.ofNullable((Card)this.session.createQuery("from Card c where c.studentId = :studentId and nextDisplayDate <= :tomorrowMidnight order by nextDisplayDate, id").setParameter("studentId", (Object)userID).setParameter("tomorrowMidnight", (Object)this.tomorrowMidnight()).setMaxResults(1).uniqueResult());
        return answered.map(c -> c.getRepetitionId()).orElse(null);
    }

    public DateTime lastAnswerFromTodayOrElse(Long studentId, DateTime fallback) {
        return Optional.ofNullable((DateTime)this.session.createQuery("select nextDisplayDate from Card where nextDisplayDate < :tomorrowMidnight and studentId=:studentId").setParameter("tomorrowMidnight", (Object)this.tomorrowMidnight()).setParameter("studentId", (Object)studentId).setMaxResults(1).uniqueResult()).orElse(fallback);
    }

    private DateTime tomorrowMidnight() {
        return DateTime.now().plusDays(1).toLocalDate().toDateTimeAtStartOfDay();
    }

    public Card getOrCreate(SpacedRepetition repetition, long userId) {
        return Optional.ofNullable((Card)this.session.createQuery("from Card where studentId = :studentId and repetitionId = :repetitionId").setParameter("studentId", (Object)userId).setParameter("repetitionId", (Object)repetition.getIdentifier()).setMaxResults(1).uniqueResult()).orElseGet(() -> this.save(new Card(repetition, userId)));
    }
}

