package br.com.caelum.srs.service;

import br.com.caelum.srs.SpacedRepetition;
import br.com.caelum.srs.dao.*;
import br.com.caelum.srs.model.*;
import org.joda.time.DateTime;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import java.util.*;
import java.util.function.Supplier;

import static org.joda.time.DateTime.now;

@Dependent
public class CardAnswerer {

	private final CardAnswerDAO answers;
	private final CardDAO cards;

	@Inject
	public CardAnswerer(CardDAO cards, CardAnswerDAO answers) {
		this.cards = cards;
		this.answers = answers;
	}

	public CardAnswer answerFillTheBlank(SpacedRepetition repetition, long userId, List<String> acceptableAnswers, String guess, AnswerKind answerKind) {
		double difference = acceptableAnswers
			.stream()
			.mapToDouble(s -> new EditDistance(s, guess).difference())
			.sorted()
			.findFirst()
			.orElseThrow(complain());

		Card card = cards.getOrCreate(repetition, userId);
		Difficulty difficulty = card.getState().difficultyFor(difference);

		return answer(repetition, userId, difficulty, answerKind);
	}

	public CardAnswer answer(SpacedRepetition repetition, long userId, Difficulty difficulty, AnswerKind answerKind) {
		Card card = cards.getOrCreate(repetition, userId);
		DateTime lastAnswerToday = cards.lastAnswerFromTodayOrElse(userId, now());
		CardAnswer answer = card.answer(difficulty, lastAnswerToday, answerKind);
		answers.save(answer);
		return answer;
	}

	private Supplier<IllegalStateException> complain() {
		return () -> new IllegalStateException("Fill the blank exercise must have at least one answer");
	}
}
