package br.com.caelum.srs.model;

import javax.persistence.*;

import static java.lang.Math.min;

@Embeddable
public class Move {

	static final int STREAK_FOR_NEXT_DAY = 6;
	static final int ONE_DAY = 24 * 60;
	static final double MAX_EASINESS = 2.48;

	@Enumerated(EnumType.STRING)
	private final CardState state;

	@Column(name = "moveInterval")
	private final int interval;

	private final double easiness;

	/**
	 * @deprecated hibernate eyes only
	 */
	protected Move() {
		this(null, 0, 0);
	}

	public Move(CardState state, int interval, double easiness) {
		this.state = state;
		this.interval = min(interval, 365 * 60 * 24);
		this.easiness = min(easiness, MAX_EASINESS);
	}

	public Move(CardState state, int interval) {
		this(state, interval, MAX_EASINESS);
	}

	public CardState getState() {
		return state;
	}

	public double getEasiness() {
		return easiness;
	}

	public Move move(Difficulty difficulty, int blackoutStreak) {
		Move next = state.move(difficulty, this);

		if (blackoutStreak == STREAK_FOR_NEXT_DAY) {
			return new Move(next.getState(), ONE_DAY, next.getEasiness()); 
		}
		
		return next;
	}

	public int getInterval() {
		return interval;
	}

	public Move move(Difficulty difficulty) {
		return move(difficulty, 0);
	}
}
