/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.srs.service;

import javax.enterprise.inject.Vetoed;

@Vetoed
public class EditDistance {
    private String correct;
    private String guess;

    public EditDistance(String correct, String guess) {
        this.correct = correct;
        this.guess = guess;
    }

    public double difference() {
        int maxLength = this.correct.length();
        if (maxLength == 0) {
            return 0.0;
        }
        double distance = this.distance();
        double difference = distance / (double)maxLength;
        double limitedDifference = Math.min(Math.max(difference, 0.0), 1.0);
        return limitedDifference;
    }

    public int distance() {
        String word1 = this.correct.toLowerCase();
        String word2 = this.guess.toLowerCase();
        int length1 = word1.length();
        int length2 = word2.length();
        int[][] distance = EditDistance.baseMatrixFor(length1, length2);
        for (int i = 1; i <= length1; ++i) {
            for (int j = 1; j <= length2; ++j) {
                int bestSoFar = Math.min(distance[i - 1][j], distance[i][j - 1]) + 1;
                boolean same = word1.charAt(i - 1) == word2.charAt(j - 1);
                int weight = same ? 0 : 1;
                int previous = distance[i - 1][j - 1];
                distance[i][j] = Math.min(bestSoFar, previous + weight);
            }
        }
        return distance[length1][length2];
    }

    private static int[][] baseMatrixFor(int length1, int length2) {
        int i;
        int[][] distance = new int[length1 + 1][length2 + 1];
        for (i = 0; i <= length1; ++i) {
            distance[i][0] = i;
        }
        for (i = 1; i <= length2; ++i) {
            distance[0][i] = i;
        }
        return distance;
    }
}

