package br.com.caelum.srs.model;

import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

import javax.persistence.*;

import static javax.persistence.EnumType.STRING;
import static org.joda.time.DateTime.now;

@Entity
public class CardAnswer {

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@ManyToOne
	private final Card card;

	@Enumerated(STRING)
	private final Difficulty difficulty;

	@Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
	private final DateTime creationDate = now();

	@Embedded
	private final Move move;

	@Enumerated(STRING)
	private final AnswerKind answerKind;

	/**
	 * @deprecated hibernate eyes only
	 */
	protected CardAnswer() {
		this(null, null, null, null);
	}

	public CardAnswer(Card card, Difficulty difficulty, Move move, AnswerKind answerKind) {
		this.card = card;
		this.difficulty = difficulty;
		this.move = move;
		this.answerKind = answerKind;
	}

	public Difficulty getDifficulty() {
		return difficulty;
	}

	public Move getMove() {
		return move;
	}

	public DateTime getCreationDate() {
		return creationDate;
	}
	
	public Card getCard() {
		return card;
	}

}
