package br.com.caelum.srs.dao;

import br.com.caelum.srs.model.CardAnswer;
import org.hibernate.Session;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;

import static br.com.caelum.srs.model.AnswerKind.REPETITION_ANSWER;
import static org.joda.time.LocalDateTime.now;

@RequestScoped
public class CardAnswerDAO {

	private final Session session;

	/**
	 * @deprecated cdi eyes only
	 */
	protected CardAnswerDAO() {
		this(null);
	}

	@Inject
	public CardAnswerDAO(Session session) {
		this.session = session;
	}


	public Long repetitionsAnsweredToday(Long studentId){
		return (Long) session.createQuery("select count(ca.id) from CardAnswer ca Join ca.card  c where ca.answerKind = :repetition and date(ca.creationDate) = :now and c.studentId = :studentId ")
				.setParameter("studentId", studentId)
				.setParameter("repetition", REPETITION_ANSWER)
				.setParameter("now", now().toDate()).uniqueResult();

	}


	public void save(CardAnswer answer) {
		session.save(answer);
	}
}
