/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.seleniumdsl.table;

import br.com.caelum.seleniumdsl.search.RowMatcher;
import br.com.caelum.seleniumdsl.search.RowVisitor;
import br.com.caelum.seleniumdsl.search.TableCriteria;
import br.com.caelum.seleniumdsl.table.Cell;
import br.com.caelum.seleniumdsl.table.Column;
import br.com.caelum.seleniumdsl.table.DefaultCell;
import br.com.caelum.seleniumdsl.table.DefaultColumn;
import br.com.caelum.seleniumdsl.table.DefaultRow;
import br.com.caelum.seleniumdsl.table.Row;
import br.com.caelum.seleniumdsl.table.Table;
import br.com.caelum.seleniumdsl.table.layout.TableLayout;
import br.com.caelum.seleniumdsl.table.layout.TableLayoutChooser;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;

public class DefaultTable
implements Table {
    private final Selenium selenium;
    private final String id;
    private final String type;
    private final TableLayout layout;

    public DefaultTable(Selenium selenium, String id) {
        this(selenium, id, "id");
    }

    public DefaultTable(Selenium selenium, String value, String type) {
        this.selenium = selenium;
        this.id = value;
        this.type = type;
        this.layout = new TableLayoutChooser(selenium, value, type).choose();
    }

    public String getType() {
        return this.type;
    }

    public Column column(int columnIndex) {
        return new DefaultColumn(this, this.selenium, columnIndex);
    }

    public Column column(String columnName) {
        return this.column(this.findColumn(columnName));
    }

    public int getColCount() {
        return this.layout.getColCount();
    }

    public int getRowCount() {
        return this.layout.getRowCount();
    }

    public int getContentCount() {
        return this.layout.getContentCount();
    }

    public Cell cell(int row, int col) {
        return new DefaultCell(this.selenium, this, row, col);
    }

    public Cell cell(int row, String col) {
        return new DefaultCell(this.selenium, this, row, this.findColumn(col));
    }

    public String getId() {
        return this.id;
    }

    public boolean exists() {
        return this.selenium.isElementPresent(this.getId());
    }

    public void iterate(RowVisitor visitor) {
        int count = this.getRowCount();
        for (int row = 1; row <= count; ++row) {
            visitor.visit(new DefaultRow(this, this.selenium, row));
        }
    }

    public Row header() {
        return this.row(1);
    }

    public Row row(Integer row) {
        return new DefaultRow(this, this.selenium, row);
    }

    public Integer findColumn(String columnName) {
        DefaultRow row = new DefaultRow(this, this.selenium, 1);
        int colCount = this.getColCount();
        for (int i = 0; i < colCount; ++i) {
            String current;
            try {
                current = row.cell(i + 1).headerValue();
            }
            catch (SeleniumException e) {
                current = row.cell(i + 1).value();
            }
            if (!columnName.equals(current)) continue;
            return i + 1;
        }
        throw new IllegalArgumentException("Column " + columnName + " not found");
    }

    public RowMatcher select(RowMatcher matcher) {
        matcher.setTable(this);
        return matcher;
    }

    public TableCriteria createCriteria() {
        return new TableCriteria(this);
    }

    public TableLayout getLayout() {
        return this.layout;
    }
}

