/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.seleniumdsl.table;

import br.com.caelum.seleniumdsl.table.Cell;
import br.com.caelum.seleniumdsl.table.Table;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;

public class DefaultCell
implements Cell {
    private final Table table;
    private final int row;
    private final int col;
    private final Selenium selenium;

    public DefaultCell(Selenium selenium, Table table, int row, int col) {
        this.selenium = selenium;
        this.table = table;
        this.row = row;
        this.col = col;
    }

    public String value() {
        return this.table.getLayout().value(this.row, this.col);
    }

    public String getLink() {
        return this.selenium.getEval("dom=selenium.page().findElement(\"" + this.getXPath() + "/a\").href");
    }

    public String headerValue() {
        try {
            return this.table.getLayout().headerValue(this.col);
        }
        catch (SeleniumException e) {
            return this.headerLinkValue();
        }
    }

    public String headerLinkValue() {
        return this.table.getLayout().headerLinkValue(this.col);
    }

    private String getXPath() {
        return "//table[@" + this.table.getType() + "='" + this.table.getId() + "']/*/tr[" + this.row + "]/td[" + this.col + "]";
    }

    public Cell check() {
        this.selenium.check(this.getXPath() + "/input");
        return this;
    }

    public Cell uncheck() {
        this.selenium.uncheck(this.getXPath() + "/input");
        return this;
    }

    public boolean checked() {
        return this.selenium.isChecked(this.getXPath() + "/input");
    }

    public boolean contains(String content) {
        return content.equals(this.value());
    }
}

