/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.seleniumdsl.table.layout;

import br.com.caelum.seleniumdsl.table.Table;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.util.logging.Logger;

class TableLayoutHelper {
    private static final Logger log = Logger.getLogger(TableLayoutHelper.class.getName());
    private Selenium selenium;
    private String id;
    private String type;

    TableLayoutHelper(Selenium selenium, String id, String type) {
        this.selenium = selenium;
        this.id = id;
        this.type = type;
    }

    int getRowCount() {
        return this.countXPath("/*/tr");
    }

    int countXPath(String expr) {
        return this.selenium.getXpathCount("//table[@" + this.type + "='" + this.id + "']/" + expr).intValue();
    }

    String getXPathText(String expr) {
        try {
            return this.selenium.getText("xpath=//table[@" + this.type + "='" + this.id + "']/" + expr);
        }
        catch (SeleniumException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    boolean contains(Table table, String col, String content) {
        for (int i = 1; i < table.getRowCount(); ++i) {
            if (!table.cell(i, col).contains(content)) continue;
            return true;
        }
        return false;
    }
}

