/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.seleniumdsl.table;

import br.com.caelum.seleniumdsl.table.Column;
import br.com.caelum.seleniumdsl.table.Table;
import com.thoughtworks.selenium.Selenium;

public class DefaultColumn
implements Column {
    private final Table table;
    private final Selenium selenium;
    private final int columnNumber;

    public DefaultColumn(Table table, Selenium selenium, int columnNumber) {
        this.table = table;
        this.selenium = selenium;
        this.columnNumber = columnNumber;
    }

    public boolean contains(String value) {
        return this.find(value) != -1;
    }

    public int find(String value) {
        int rowCount = this.table.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            if (!this.table.cell(i, this.columnNumber).contains(value)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsPartial(String value) {
        int rowCount = this.table.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            if (!this.table.cell(i, this.columnNumber).value().contains(value)) continue;
            return true;
        }
        return false;
    }
}

