/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.mediatype;

import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.client.DefaultLinkConverter;
import br.com.caelum.restfulie.http.DefaultRelation;
import br.com.caelum.restfulie.mediatype.MediaType;
import br.com.caelum.restfulie.mediatype.XStreamHelper;
import br.com.caelum.restfulie.opensearch.conveter.DefaultUrlConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.inflector.Noun;
import org.jvnet.inflector.Pluralizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMediaType
implements MediaType {
    private final List<String> types = Arrays.asList("application/xml", "text/xml", "xml", "application/opensearchdescription+xml");
    private final XStreamHelper helper;
    private XStream xstream;
    private List<Class> typesToEnhance = new ArrayList<Class>();
    private List<String> names = new ArrayList<String>();

    public XmlMediaType() {
        QNameMap qnameMap = new QNameMap();
        QName qname = new QName("http://www.w3.org/2005/Atom", "atom");
        qnameMap.registerMapping(qname, DefaultRelation.class);
        XmlFriendlyReplacer replacer = new XmlFriendlyReplacer("$", "_");
        this.helper = new XStreamHelper((HierarchicalStreamDriver)new StaxDriver(qnameMap, replacer));
    }

    protected void configure(XStream xstream) {
    }

    @Override
    public boolean answersTo(String type) {
        return this.types.contains(type);
    }

    @Override
    public <T> void marshal(T payload, Writer writer, RestClient client) throws IOException {
        this.getXstream(client).toXML(this.getPayload(payload), writer);
        writer.flush();
    }

    private Object getPayload(Object payload) {
        if (payload instanceof Collection) {
            return new ArrayList((Collection)payload);
        }
        return payload;
    }

    @Override
    public <T> T unmarshal(String content, RestClient client) {
        XStream xstream = this.getXstream(client);
        xstream.registerConverter((Converter)new DefaultLinkConverter(client));
        xstream.registerConverter((Converter)new DefaultUrlConverter(client));
        return (T)xstream.fromXML(content);
    }

    private List<Class> getTypesToEnhance() {
        return this.typesToEnhance;
    }

    private List<String> getCollectionNames(RestClient client) {
        for (Class type : this.typesToEnhance) {
            String plural = Noun.pluralOf((String)type.getSimpleName(), (Pluralizer)client.inflectionRules());
            this.names.add(Character.toLowerCase(plural.charAt(0)) + plural.substring(1));
        }
        return this.names;
    }

    public XmlMediaType withTypes(Class ... classes) {
        this.typesToEnhance.addAll(Arrays.asList(classes));
        return this;
    }

    private XStream getXstream(RestClient client) {
        if (this.xstream == null) {
            this.xstream = this.helper.getXStream(this.getTypesToEnhance(), this.getCollectionNames(client));
            this.configure(this.xstream);
        }
        return this.xstream;
    }

    public void withCollectionName(String ... names) {
        for (String name : names) {
            this.names.add(name);
        }
    }
}

