/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.mediatype;

import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.client.DefaultLinkConverter;
import br.com.caelum.restfulie.mediatype.MediaType;
import br.com.caelum.restfulie.mediatype.XStreamHelper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMediaType
implements MediaType {
    public static final String TYPE = "application/json";
    private final List<String> types = Arrays.asList("application/json", "text/json", "json");
    private final XStreamHelper helper = new XStreamHelper((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
    private final XStream xstream = this.helper.getXStream(this.getTypesToEnhance(), this.getCollectionNames());

    public JsonMediaType() {
        this.configure(this.xstream);
    }

    protected void configure(XStream xstream) {
    }

    @Override
    public boolean answersTo(String type) {
        return this.types.contains(type);
    }

    @Override
    public <T> void marshal(T payload, Writer writer, RestClient client) throws IOException {
        if (payload.getClass().equals(String.class)) {
            writer.append((CharSequence)String.class.cast(payload));
            return;
        }
        this.xstream.toXML(payload, writer);
        writer.flush();
    }

    @Override
    public <T> T unmarshal(String content, RestClient client) {
        this.xstream.registerConverter((Converter)new DefaultLinkConverter(client));
        return (T)this.xstream.fromXML(content);
    }

    protected List<Class> getTypesToEnhance() {
        return Collections.emptyList();
    }

    protected List<String> getCollectionNames() {
        return Collections.emptyList();
    }
}

