/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.restfulie.http.javanet;

import br.com.caelum.restfulie.Response;
import br.com.caelum.restfulie.RestClient;
import br.com.caelum.restfulie.RestfulieException;
import br.com.caelum.restfulie.http.ContentProcessor;
import br.com.caelum.restfulie.http.Headers;
import br.com.caelum.restfulie.http.HttpURLConnectionContentProcessor;
import br.com.caelum.restfulie.http.Request;
import br.com.caelum.restfulie.http.javanet.MapHeaders;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaNetResponse
implements Response {
    private int code;
    private Headers headers;
    private HttpURLConnection connection;
    private ContentProcessor processor;
    private final RestClient client;
    private final Request request;

    public JavaNetResponse(HttpURLConnection connection, RestClient client, Request request) throws IOException {
        this(connection, client, new HttpURLConnectionContentProcessor(connection), request);
    }

    public JavaNetResponse(HttpURLConnection connection, RestClient client, ContentProcessor processor, Request request) throws IOException {
        this.client = client;
        this.request = request;
        this.code = connection.getResponseCode();
        this.connection = connection;
        this.headers = new MapHeaders(connection.getHeaderFields());
        this.processor = processor;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getContent() {
        try {
            return this.processor.read();
        }
        catch (IOException e) {
            throw new RestfulieException("Unable to parse response content", e);
        }
    }

    @Override
    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Override
    public <T> T getResource() {
        String contentType = this.getContentType();
        String content = this.getContent();
        return this.client.getMediaTypes().forContentType(contentType).unmarshal(content, this.client);
    }

    private String getContentType() {
        return this.headers.getMain("Content-Type");
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public URI getLocation() {
        try {
            return new URI(this.headers.getMain("Location"));
        }
        catch (URISyntaxException e) {
            throw new RestfulieException("Invalid URI received as a response", e);
        }
    }

    @Override
    public String getType() {
        return this.getContentType();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public String getStatusLine() {
        try {
            return this.connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new RestfulieException("Invalid Status line", e);
        }
    }
}

